class Mutator_StatsHandler extends Mutator config(MH2Database);

// database config vars:
var config string 	SPlayer[10000];
var config int 		SFrags[10000],
			SDeaths[10000],
			SGold[10000],
			SSouls[10000],
			LightRadius[10000],
			HealthMax[10000],
			HealthRegain[10000],
			AmmoRegain[10000],
			bHasLawgiver[10000],
			bHasRailgun[10000],
			bHasHeadremover[10000],
			bHasInstigator[10000],
			bHasShredder[10000],
			bHasBlaster[10000];


// temp statistic vars, these will be xfered when the game ends.
var string TempPlayer[100];
var int TempFrags[100], TempDeaths[100], TempGold[100], TempSouls[100], TempLightRadius[100], TempHealthMax[100], TempHealthRegain[100], TempAmmoRegain[100], TempbHasLawgiver[100];
var int TempbHasRailgun[100], TempbHasHeadremover[100], TempbHasInstigator[100], TempbHasShredder[100], TempbHasBlaster[100];
var bool bResetTempVars, bRunOnce;

// misc variables
var bool bTempDataMoved;
var bool Init;
var int TimerEvent;

function PreBeginPlay()
{
	InitStats();
	bTempDataMoved = False;
	GetTopPlayers();
	log("Mutator_Statshandler initialized");
}

function InitStats()
{
local int i;

	if ( !bResetTempVars )
		{
		for ( i=0; i<100; i++ )
			{
			TempPlayer[i] = "";
			TempFrags[i] = 0;
			TempDeaths[i] = 0;
			TempGold[i] = 0;
			TempSouls[i] = 0;
			TempLightRadius[i] = 0;
			TempHealthMax[i] = 0;
			TempHealthRegain[i] = 0;
			TempAmmoRegain[i] = 0;
			TempbHasLawgiver[i] = 0;
			TempbHasRailgun[i] = 0;
			TempbHasHeadremover[i] = 0;
			TempbHasInstigator[i] = 0;
			TempbHasShredder[i] = 0;
			TempbHasBlaster[i] = 0;
			}
		bResetTempVars = True;
		log("Monsterhunt2 - The mutator is active and gathering runtime stats on the players.");
		}
}

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	//Enable the Timer function, and set time interval
	settimer(0.1, true);
}

function Timer()
{
local int i,ii;

	if (TimerEvent == 0)
		{
		GrabScoreFromDB();
		TimerEvent++;
		}
	else if (TimerEvent == 1)
		{
		SetPlayerRanks();
		TimerEvent = 0;
		}
}

//This function looks at each players score and assign the correct rank
function SetPlayerRanks()
{
local Pawn P;
local Info_PRI IPRI;
local int Score;
local string Rank;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
    		{
		if (P.IsA('PlayerPawn'))
			{
			Score = int(PlayerPawn(P).PlayerReplicationInfo.Score);
			
			if ( Score < 20000 )
				Rank = "Recruit";
			else if ( Score < 40000 )
				Rank = "Private";
			else if ( Score < 60000 )
				Rank = "Corporal";
			else if ( Score < 80000 )
				Rank = "Sergeant";
			else if ( Score < 100000 )
				Rank = "Staff Sergeant";
			else if ( Score < 120000 )
				Rank = "Sergeant First Class";
			else if ( Score < 150000 )
				Rank = "Master Sergeant";
			else if ( Score < 200000 )
				Rank = "Second Lieutenant";
			else if ( Score < 400000 )
				Rank = "First Lieutenant";
			else if ( Score < 800000 )
				Rank = "Captain";
			else if ( Score < 1200000 )
				Rank = "Major";
			else if ( Score < 1800000 )
				Rank = "Colonel";
			else if ( Score < 2400000 )
				Rank = "1-star General";
			else if ( Score < 3000000 )
				Rank = "2-star General";
			else
				Rank = "Marshal";
		
			Info_PRI(PlayerPawn(P).PlayerReplicationInfo).Rank = Rank;
			}
		else if (P.IsA('Bot'))
			{
			Score = int(Bot(P).PlayerReplicationInfo.Score);
			
			if ( Score < 20000 )
				Rank = "Recruit";
			else if ( Score < 40000 )
				Rank = "Private";
			else if ( Score < 60000 )
				Rank = "Corporal";
			else if ( Score < 80000 )
				Rank = "Sergeant";
			else if ( Score < 100000 )
				Rank = "Staff Sergeant";
			else if ( Score < 120000 )
				Rank = "Sergeant First Class";
			else if ( Score < 150000 )
				Rank = "Master Sergeant";
			else if ( Score < 200000 )
				Rank = "Second Lieutenant";
			else if ( Score < 400000 )
				Rank = "First Lieutenant";
			else if ( Score < 800000 )
				Rank = "Captain";
			else if ( Score < 1200000 )
				Rank = "Major";
			else if ( Score < 1800000 )
				Rank = "Colonel";
			else if ( Score < 2400000 )
				Rank = "1-star General";
			else if ( Score < 3000000 )
				Rank = "2-star General";
			else
				Rank = "Marshal";

			Info_PRI(Bot(P).PlayerReplicationInfo).Rank = Rank;
			}
		}
}

function ScoreKill(Pawn Killer, Pawn Other)
{
local string KillerName, VictimName;

	if ( Other.IsA('PlayerPawn'))
		{
		PlayerPawn(Other).PlayerReplicationInfo.Deaths +=1;
		PlayerPawn(Other).PlayerReplicationInfo.Score -=1;
		}
	else if ( Other.IsA('Bot'))
		{
		Bot(Other).PlayerReplicationInfo.Deaths +=1;
		Bot(Other).PlayerReplicationInfo.Score -=1;
		}

	if ( Killer == None || Other == None )
		{
		return;
		}	

	//set killer name
	if ( Killer.IsA('ScriptedPawn') )
		{
		if ( Killer.Tag != '' )
			{
			KillerName = string(Killer.Tag);
			}
		else
			{
			KillerName = "Unnamed monster";
			}
		}
	else if ( Killer.bIsPlayer )
		{
		KillerName = Killer.PlayerReplicationInfo.PlayerName;
		}

	//set victim name
	if ( Other.IsA('ScriptedPawn') )
		{
		if ( Other.Tag != '' )
			{
			VictimName = string(Other.Tag);
			}
		else
			{
			VictimName = "Unnamed monster";
			}
		}

	else if ( Other.bIsPlayer )
		{
		VictimName = Other.PlayerReplicationInfo.PlayerName;
		}

	if ( Killer != Other)
 		{
		BroadcastMessage(KillerName@"killed"@VictimName);
 		}

	CollectData();
}

//This function updates the players score everytime a kill is made in-game
function CollectData()
{
local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn') || P.IsA('Bot'))
			{
			for ( i=0; i<100; i++ )
				{
				if (( P.PlayerReplicationInfo.PlayerName == TempPlayer[i] ) || ( TempPlayer[i] == "" ))
					{
					TempPlayer[i] = P.PlayerReplicationInfo.PlayerName;
					TempFrags[i] = P.PlayerReplicationInfo.Score;
					TempDeaths[i] = P.PlayerReplicationInfo.Deaths;
					TempGold[i] = Info_PRI(P.PlayerReplicationInfo).GoldAmount;
					TempSouls[i] = Info_PRI(P.PlayerReplicationInfo).Souls;
					TempLightRadius[i] = Info_PRI(P.PlayerReplicationInfo).LightRadius;
					TempHealthMax[i] = Info_PRI(P.PlayerReplicationInfo).HealthMax;
					TempHealthRegain[i] = Info_PRI(P.PlayerReplicationInfo).HealthRegain;
					TempAmmoRegain[i] = Info_PRI(P.PlayerReplicationInfo).AmmoRegain;
					TempbHasLawgiver[i] = Info_PRI(P.PlayerReplicationInfo).bHasLawgiver;
					TempbHasRailgun[i] = Info_PRI(P.PlayerReplicationInfo).bHasRailgun;
					TempbHasHeadremover[i] = Info_PRI(P.PlayerReplicationInfo).bHasHeadremover;
					TempbHasInstigator[i] = Info_PRI(P.PlayerReplicationInfo).bHasInstigator;
					TempbHasShredder[i] = Info_PRI(P.PlayerReplicationInfo).bHasShredder;
					TempbHasBlaster[i] = Info_PRI(P.PlayerReplicationInfo).bHasBlaster;
					i = 200;
					}
				}
			}
		}
}

function GrabScoreFromDB() 
{
local int i,ii;
local Pawn P;
local Info_PRI Info_PRI;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn') && P.Tag != 'Checked')
			{	
			for (ii=0;ii<10000;ii++)
				{
				if (P.PlayerReplicationInfo.PlayerName == SPlayer[ii] || SPlayer[ii] == "")
					{
					SPlayer[ii] = P.PlayerReplicationInfo.PlayerName;
					P.PlayerReplicationInfo.Score = SFrags[ii];
					P.PlayerReplicationInfo.Deaths = SDeaths[ii];
					Info_PRI(P.PlayerReplicationInfo).GoldAmount = SGold[ii];
					Info_PRI(P.PlayerReplicationInfo).Souls = SSouls[ii];
					Info_PRI(P.PlayerReplicationInfo).LightRadius = LightRadius[ii];
					Info_PRI(P.PlayerReplicationInfo).HealthMax = HealthMax[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasLawgiver = bHasLawgiver[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasRailgun = bHasRailgun[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasHeadremover = bHasHeadremover[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasInstigator = bHasInstigator[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasShredder = bHasShredder[ii];
					Info_PRI(P.PlayerReplicationInfo).bHasBlaster = bHasBlaster[ii];
					if ( Info_PRI(P.PlayerReplicationInfo).HealthMax < 200 )
						{
						Info_PRI(P.PlayerReplicationInfo).HealthMax = 200;
						}
					Info_PRI(P.PlayerReplicationInfo).HealthRegain = HealthRegain[ii];
					Info_PRI(P.PlayerReplicationInfo).AmmoRegain = AmmoRegain[ii];
					P.Tag = 'Checked';
					//give weapons:
					if ( Info_PRI(P.PlayerReplicationInfo).bHasLawgiver == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Lawgiver");
						}
					if ( Info_PRI(P.PlayerReplicationInfo).bHasRailgun == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Railgun");
						}
					if ( Info_PRI(P.PlayerReplicationInfo).bHasHeadremover == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Headremover");
						}
					if ( Info_PRI(P.PlayerReplicationInfo).bHasInstigator == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Instigator");
						}
					if ( Info_PRI(P.PlayerReplicationInfo).bHasShredder == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Shredder");
						}
					if ( Info_PRI(P.PlayerReplicationInfo).bHasBlaster == 1 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Blaster");
						}
					DeathMatchPlus(Level.Game).GiveWeapon(P,"Monsterhunt2.MH2_Weapon_Blaster");
					ii=20000;
					}
				}
	
			}
		else if (P.IsA('Bot') && P.Tag != 'Checked')
			{	
			for (ii=0;ii<10000;ii++)
				{
				if (P.PlayerReplicationInfo.PlayerName == SPlayer[ii] || SPlayer[ii] == "")
					{
					SPlayer[ii] = P.PlayerReplicationInfo.PlayerName;
					P.PlayerReplicationInfo.Score = SFrags[ii];
					P.PlayerReplicationInfo.Deaths = SDeaths[ii];
					P.Tag = 'Checked';
					ii=20000;
					}
				}
	
			}
		}
}

function HandleStats()
{
local Pawn P;
local int i,ii,a;

if ( !bRunOnce )
	{
	for (P = Level.PawnList; P != None; P = P.NextPawn)
	{
	if (P.IsA('Bot') || P.IsA('PlayerPawn'))
		{
		for ( i=0; i<100; i++ )
			{
			if (( P.PlayerReplicationInfo.PlayerName == TempPlayer[i] ) || ( TempPlayer[i] == "" ))
				{
				TempPlayer[i] = P.PlayerReplicationInfo.PlayerName;
				TempFrags[i] = P.PlayerReplicationInfo.Score;
				TempDeaths[i] = P.PlayerReplicationInfo.Deaths;
				TempGold[i] = Info_PRI(P.PlayerReplicationInfo).GoldAmount;
				TempSouls[i] = Info_PRI(P.PlayerReplicationInfo).Souls;
				TempLightRadius[i] = Info_PRI(P.PlayerReplicationInfo).LightRadius;
				TempHealthMax[i] = Info_PRI(P.PlayerReplicationInfo).HealthMax;
				TempHealthRegain[i] = Info_PRI(P.PlayerReplicationInfo).HealthRegain;
				TempAmmoRegain[i] = Info_PRI(P.PlayerReplicationInfo).AmmoRegain;
				TempbHasLawgiver[i] = Info_PRI(P.PlayerReplicationInfo).bHasLawgiver;
				TempbHasRailgun[i] = Info_PRI(P.PlayerReplicationInfo).bHasRailgun;
				TempbHasHeadremover[i] = Info_PRI(P.PlayerReplicationInfo).bHasHeadremover;
				TempbHasInstigator[i] = Info_PRI(P.PlayerReplicationInfo).bHasInstigator;
				TempbHasShredder[i] = Info_PRI(P.PlayerReplicationInfo).bHasShredder;
				TempbHasBlaster[i] = Info_PRI(P.PlayerReplicationInfo).bHasBlaster;
				i = 200;
				}
			}
		}
	for ( i=0; i<100; i++ )
			{
			if ( TempPlayer[i] != "" )
				{
				for ( ii=0; ii<10000; ii++ )
					{
					if (( TempPlayer[i] == SPlayer[ii] ) || ( SPlayer[ii] == "" ))
						{
						SPlayer[ii] = TempPlayer[i];
						SFrags[ii] = TempFrags[i];
						SDeaths[ii] = TempDeaths[i];
						SGold[ii] = TempGold[i];
						SSouls[ii] = TempSouls[i];
						LightRadius[ii] = TempLightRadius[i];
						HealthMax[ii] = TempHealthMax[i];
						HealthRegain[ii] = TempHealthRegain[i];
						AmmoRegain[ii] = TempAmmoRegain[i];
						bHasLawgiver[ii] = TempbHasLawgiver[i];
						bHasRailgun[ii] = TempbHasRailgun[i];
						bHasHeadremover[ii] = TempbHasHeadremover[i];
						bHasInstigator[ii] = TempbHasInstigator[i];
						bHasShredder[ii] = TempbHasShredder[i];
						bHasBlaster[ii] = TempbHasBlaster[i];
						TempPlayer[i] = "";
						TempFrags[i] = 0;
						TempDeaths[i] = 0;
						TempGold[i] = 0;
						TempSouls[i] = 0;
						TempLightRadius[i] = 0;
						TempHealthMax[i] = 0;
						TempHealthRegain[i] = 0;
						TempAmmoRegain[i] = 0;
						TempbHasLawgiver[i] = 0;
						TempbHasRailgun[i] = 0;
						TempbHasHeadremover[i] = 0;
						TempbHasInstigator[i] = 0;
						TempbHasShredder[i] = 0;
						TempbHasBlaster[i] = 0;
						ii = 20000;
						}
					}
				}
			}
	}
	bRunOnce = True;
	log("Monsterhunt2 - The stats have been calculated and transfered to the database.");
	}	
}

function bool HandleEndGame()
{

	HandleStats();
	SaveConfig();

}

function GetTopPlayers()
{
local int i;
local Info_GRI GRI;

	ForEach AllActors(class'Info_GRI', GRI)
		{
		//find #1
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score1 )
				{
				GRI.Score1 = SFrags[i];
				GRI.Best1 = SPlayer[i];
				}
			}
		//find #2
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score2
				&& GRI.Best1 != SPlayer[i] )
				{
				GRI.Score2 = SFrags[i];
				GRI.Best2 = SPlayer[i];
				}
			}
		//find #3
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score3
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i] )
				{
				GRI.Score3 = SFrags[i];
				GRI.Best3 = SPlayer[i];
				}
			}
		//find #4
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score4
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i] )
				{
				GRI.Score4 = SFrags[i];
				GRI.Best4 = SPlayer[i];
				}
			}
		//find #5
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score5
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i] )
				{
				GRI.Score5 = SFrags[i];
				GRI.Best5 = SPlayer[i];
				}
			}
		//find #6
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score6
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i]
				&& GRI.Best5 != SPlayer[i] )
				{
				GRI.Score6 = SFrags[i];
				GRI.Best6 = SPlayer[i];
				}
			}
		//find #7
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score7
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i]
				&& GRI.Best5 != SPlayer[i]
				&& GRI.Best6 != SPlayer[i] )
				{
				GRI.Score7 = SFrags[i];
				GRI.Best7 = SPlayer[i];
				}
			}
		//find #8
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score8
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i]
				&& GRI.Best5 != SPlayer[i]
				&& GRI.Best6 != SPlayer[i]
				&& GRI.Best7 != SPlayer[i] )
				{
				GRI.Score8 = SFrags[i];
				GRI.Best8 = SPlayer[i];
				}
			}
		//find #9
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score9
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i]
				&& GRI.Best5 != SPlayer[i]
				&& GRI.Best6 != SPlayer[i]
				&& GRI.Best7 != SPlayer[i]
				&& GRI.Best8 != SPlayer[i] )
				{
				GRI.Score9 = SFrags[i];
				GRI.Best9 = SPlayer[i];
				}
			}
		//find #10
		for (i=0;i<10000;i++)
			{
			if ( SFrags[i] > GRI.Score10
				&& GRI.Best1 != SPlayer[i]
				&& GRI.Best2 != SPlayer[i]
				&& GRI.Best3 != SPlayer[i]
				&& GRI.Best4 != SPlayer[i]
				&& GRI.Best5 != SPlayer[i]
				&& GRI.Best6 != SPlayer[i]
				&& GRI.Best7 != SPlayer[i]
				&& GRI.Best8 != SPlayer[i]
				&& GRI.Best9 != SPlayer[i] )
				{
				GRI.Score10 = SFrags[i];
				GRI.Best10 = SPlayer[i];
				}
			}
		}


}

defaultproperties
{
}
